///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Left(char *inStr, int LeftChar, char *outStr)
{
    int RPos = 0;
    int WPos = 0;

    int inStrLen = strlen(inStr);

    while(RPos < inStrLen && RPos < LeftChar)
    {
        outStr[WPos] = inStr[RPos];
        RPos++;
        WPos++;
    }

    outStr[WPos] = '\0';

    return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Right(char *inStr, int RightChar, char *outStr)
{
    int RPos = RightChar;
    int WPos = 0;

    int inStrLen = strlen(inStr);

    while(RPos < inStrLen)
    {
        outStr[WPos] = inStr[RPos];
        RPos++;
        WPos++;
    }

    outStr[WPos] = '\0';

    return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetRemoteMAC(char *inIPAddress, char *outMACAddr)
{
    HRESULT hr;
    IPAddr  ipAddr;
    ULONG   pulMac[2];
    ULONG   ulLen = 6;

    if((ipAddr = inet_addr(inIPAddress)) == INADDR_NONE)
        return false;

    memset(pulMac, 0, sizeof(pulMac));

    if( (hr = SendARP (ipAddr, 0, pulMac, &ulLen)) != NO_ERROR)
        return false;

    ULONG LoopPos = 0;
    ULONG BufPos = 0;
    PBYTE pbHexMac = (PBYTE) pulMac;

    while(LoopPos < (ulLen - 1))
    {
        BufPos += sprintf(outMACAddr + BufPos, "%02X:", pbHexMac[LoopPos]);
        LoopPos++;
    }

    sprintf(outMACAddr + BufPos, "%02X", pbHexMac[LoopPos]);

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////

bool ResolveIP(char *IPAddress, char *outHostName)
{
	unsigned long HostAddress = inet_addr(IPAddress);
    if(HostAddress == INADDR_NONE)
        return false;

	struct hostent *HostData = gethostbyaddr((char*)&HostAddress, sizeof(unsigned long), AF_INET);
	if(HostData == NULL)
		return false;

    strcpy(outHostName, HostData->h_name);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ResolveHost(char *xHostName, int AddressNum, char *outIPAddress)
{
    char *IPAddress = NULL;
    struct hostent *Host;
    struct in_addr Address;

    if((Host = gethostbyname(xHostName)) == NULL)
        return false;
    
    if(Host->h_addr_list[AddressNum] == NULL)
        return false;

    memcpy(&Address.s_addr, Host->h_addr_list[AddressNum], Host->h_length);

    if((IPAddress = inet_ntoa(Address)) == NULL)
        return false;

    strcpy(outIPAddress, IPAddress);

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetNodeInformation(char *NodeName)
{
    int AddrPos = 0;
    int MACAddrCount = 0;

    char MacAddr[255];
    char IPAddress[255];
    char HostName[255];

    bool ReturnValue = true;
    bool ResolvedHost = true;

    char IPAddressList[2048];
    char MACAddressList[2048];

    while(ResolveHost(NodeName, AddrPos, IPAddress))
    {
        if(AddrPos == 0)
        {
            strcpy(IPAddressList, IPAddress);
        }
        else{
            strcat(IPAddressList, ", ");
            strcat(IPAddressList, IPAddress);
        }

        MyLV_Item.pszText  = IPAddressList;
        MyLV_Item.mask     = LVIF_TEXT;
        MyLV_Item.iSubItem = 3;
        ListView_SetItem(LanViewListBox_hWnd, &MyLV_Item);

        if(ResolveIP(IPAddress, HostName))
        {
            MyLV_Item.pszText  = HostName;
            MyLV_Item.mask     = LVIF_TEXT;
            MyLV_Item.iSubItem = 2;
            ListView_SetItem(LanViewListBox_hWnd, &MyLV_Item);
        }
        else ReturnValue = false;

        if(GetRemoteMAC(IPAddress, MacAddr))
        {
            if(MACAddrCount == 0)
            {
                strcpy(MACAddressList, MacAddr);
            }
            else{
                strcat(MACAddressList, ", ");
                strcat(MACAddressList, MacAddr);
            }

            MyLV_Item.pszText  = MACAddressList;
            MyLV_Item.mask     = LVIF_TEXT;
            MyLV_Item.iSubItem = 4;
            ListView_SetItem(LanViewListBox_hWnd, &MyLV_Item);

            MACAddrCount++;
        }
        else ReturnValue = false;

        ResolvedHost = true;
        AddrPos++;
    }

    if(!ResolvedHost)
        return false;

    return ReturnValue;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL GetNetworkResources(void)
{
    DWORD Status      = 0;
    HANDLE EnumHandle = 0;
    DWORD cbBuffer    = 5 * 1024;
    DWORD cEntries    = 0xFFFFFFFF;
    char Temp[1024];

    NETRESOURCE *LPNR;

    Status = WNetOpenEnum(RESOURCE_CONTEXT, RESOURCETYPE_ANY, 0, NULL, &EnumHandle);
    if (Status != NO_ERROR)
    {
        ErrorMessage("Error in GetNetworkResources: WNetOpenEnum error.");
        return FALSE;
    }

    LPNR = (NETRESOURCE *) calloc(cbBuffer, 1);

	while( (Status = WNetEnumResource(EnumHandle, &cEntries, LPNR, &cbBuffer)) == NO_ERROR)
    {
        DWORD LocalLoop = 0;

        while(LocalLoop < cEntries)
        {
            if(LPNR[LocalLoop].lpRemoteName)
            {
                if( LPNR[LocalLoop].dwDisplayType == RESOURCEUSAGE_CONTAINER)
                {
                    giContainerCount++;

                    Set_Text(StatusText_hWnd, LPNR[LocalLoop].lpRemoteName);

                    MyLV_Item.mask     = LVIF_IMAGE;
                    MyLV_Item.iSubItem = 0;
                    MyLV_Item.iImage   = 0;
                    ListView_InsertItem(LanViewListBox_hWnd, &MyLV_Item);

                    MyLV_Item.pszText  = LPNR[LocalLoop].lpRemoteName;
                    MyLV_Item.mask     = LVIF_TEXT;
                    MyLV_Item.iSubItem = 1;
                    ListView_SetItem(LanViewListBox_hWnd, &MyLV_Item);

                    MyLV_Item.pszText  = LPNR[LocalLoop].lpComment;
                    MyLV_Item.mask     = LVIF_TEXT;
                    MyLV_Item.iSubItem = 5;
                    ListView_SetItem(LanViewListBox_hWnd, &MyLV_Item);

                    Right(LPNR[LocalLoop].lpRemoteName, 2, Temp);

                    if(GetNodeInformation(Temp))
                    {
                        MyLV_Item.mask     = LVIF_IMAGE;
                        MyLV_Item.iSubItem = 0;
                        MyLV_Item.iImage   = 0;
                        ListView_SetItem(LanViewListBox_hWnd, &MyLV_Item);
                    }
                    else{
                        MyLV_Item.mask     = LVIF_IMAGE;
                        MyLV_Item.iSubItem = 0;
                        MyLV_Item.iImage   = 1;
                        ListView_SetItem(LanViewListBox_hWnd, &MyLV_Item);
                    }

                }
            }
            LocalLoop++;
            Sleep(1);
        }
        Sleep(1);
    }

    Sleep(1);

    free(LPNR);

    WNetCloseEnum(EnumHandle);

    return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int GetLANInfo(void)
{
    DWORD Result = 0;

    memset(&MyLV_Item, 0, sizeof(LV_ITEM));

    WORD WSARequiredVersion;
    WSADATA WSAData;
    WSADATA *WSAPointerData;

    // -------- WINSOCK STARTUP --------
    WSARequiredVersion = 0x0101; // Version 1.1
    WSAPointerData = &WSAData;
    if((Result = WSAStartup(WSARequiredVersion, WSAPointerData)) != 0)
    {
        ErrorMessage("Error in GetLANInfo: WSAStartup error.");
        return 0;
    }

    GetNetworkResources();

    if((Result = WSACleanup()) == SOCKET_ERROR)
    {
        ErrorMessage("Error in GetLANInfo: WSACleanup error.");
        return 0;
    }

    return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI POPGrid_Thread(LPVOID xData)
{
    GetLANInfo();

    Set_Text(StatusText_hWnd, "Complete.");

    Sleep(2000);

    EndDialog(ScanningDialog_hWnd, 1234);

    return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

